library(fields)
library(rgdal)
library(RColorBrewer)

# setwd("~/CNH3/Salado/data")
cuenca.A.ll <- readOGR(".", layer="Salado_A_latlon", verbose = TRUE)

# setwd("~/CNH3/Salado/conditional/drafts/editing/editing-round2/moderate-revisions")
load("~/CNH3/Salado/2015-08-04_gridProj-IRI-OND2010.RData")

SIMseatot.proj.NOST <- apply(SIMamt.proj.NOST,2:3,sum)
SIMseatot.proj.ST   <- apply(SIMamt.proj.ST,  2:3,sum)

medSIMseatot.proj.NOST <- apply(SIMseatot.proj.NOST,1,median)
medSIMseatot.proj.ST   <- apply(SIMseatot.proj.ST,  1,median)

z.max.pp <- max(medSIMseatot.proj.NOST-medSIMseatot.proj.ST)
z.min.pp <- z.max.pp*-1

diff.colors.pp <- colorRampPalette(brewer.pal(7,"RdYlBu"))(50)

SIMseamax.proj.NOST <- apply(SIMtmax.proj.NOST,2:3,mean)
SIMseamax.proj.ST   <- apply(SIMtmax.proj.ST,  2:3,mean)

medSIMseamax.proj.NOST <- apply(SIMseamax.proj.NOST,1,median)
medSIMseamax.proj.ST   <- apply(SIMseamax.proj.ST,  1,median)

z.min.mx <- min(medSIMseamax.proj.NOST-medSIMseamax.proj.ST)
z.max.mx <- z.min.mx*-1#max(medSIMseamax.proj.NOST-medSIMseamax.proj.ST)

SIMseamin.proj.NOST <- apply(SIMtmin.proj.NOST,2:3,mean)
SIMseamin.proj.ST   <- apply(SIMtmin.proj.ST,  2:3,mean)

medSIMseamin.proj.NOST <- apply(SIMseamin.proj.NOST,1,median)
medSIMseamin.proj.ST   <- apply(SIMseamin.proj.ST,  1,median)

z.min.mn <- min(medSIMseamin.proj.NOST-medSIMseamin.proj.ST)
z.max.mn <- z.min.mn*-1#max(medSIMseamin.proj.NOST-medSIMseamin.proj.ST)

diff.colors <- rev(colorRampPalette(brewer.pal(7,"RdYlBu"))(50))

Salado_A_gk <- readOGR("/Users/andrew/CNH3/Salado/data/",layer="Salado_A_GK")
ext <- extent(min(predloc[,1])-2500,max(predloc[,1])+2500,min(predloc[,2])-2500,max(predloc[,2])+2500)



pdf(file="~/Desktop/Dissertation/Defense/figures/OND2010-med.pdf",width=12,height=3.5,pointsize=20)
par(mfrow=c(1,3),mar=c(2,2,2,2))

seatot.med <- raster(matrix(medSIMseatot.proj.NOST - medSIMseatot.proj.ST,nrow=74,ncol=70,byrow=T))
extent(seatot.med) <- ext 
image.plot(flip(seatot.med,2),zlim=c(z.min.pp,z.max.pp),xlab="",ylab="",main="Precip",col=diff.colors.pp,axes=F,legend.mar=7.1)
plot(Salado_A_gk,add=T,lwd=2)
box()

seamax.med <- raster(matrix(medSIMseamax.proj.NOST - medSIMseamax.proj.ST,nrow=74,ncol=70,byrow=T))
extent(seamax.med) <- ext
image.plot(flip(seamax.med,2),zlim=c(z.min.mx,z.max.mx),xlab="",ylab="",main="Max Temp",col=diff.colors,axes=F,legend.mar=7.1)
plot(Salado_A_gk,add=T,lwd=2)
box()

seamin.med <- raster(matrix(medSIMseamin.proj.NOST - medSIMseamin.proj.ST,nrow=74,ncol=70,byrow=T))
extent(seamin.med) <- ext
image.plot(flip(seamin.med,2),zlim=c(z.min.mn,z.max.mn),xlab="",ylab="",main="Min Temp",col=diff.colors,axes=F,legend.mar=7.1)
plot(Salado_A_gk,add=T,lwd=2)
box()

dev.off()



SIMseatot.proj.NOST.spread <- apply(SIMseatot.proj.NOST,1,quantile,probs=.975) - apply(SIMseatot.proj.NOST,1,quantile,probs=.025)
SIMseatot.proj.ST.spread   <- apply(SIMseatot.proj.ST,1,quantile,probs=.975) - apply(SIMseatot.proj.ST,1,quantile,probs=.025)

SIMseamax.proj.NOST.spread <- apply(SIMseamax.proj.NOST,1,quantile,probs=.975) - apply(SIMseamax.proj.NOST,1,quantile,probs=.025)
SIMseamax.proj.ST.spread   <- apply(SIMseamax.proj.ST,1,quantile,probs=.975) - apply(SIMseamax.proj.ST,1,quantile,probs=.025)

SIMseamin.proj.NOST.spread <- apply(SIMseamin.proj.NOST,1,quantile,probs=.975) - apply(SIMseamin.proj.NOST,1,quantile,probs=.025)
SIMseamin.proj.ST.spread   <- apply(SIMseamin.proj.ST,1,quantile,probs=.975) - apply(SIMseamin.proj.ST,1,quantile,probs=.025)

z.min.spread.pp <- min(SIMseatot.proj.NOST.spread - SIMseatot.proj.ST.spread)
z.max.spread.pp <- z.min.spread.pp*-1

z.min.spread.mx <- min(SIMseamax.proj.NOST.spread - SIMseamax.proj.ST.spread)
z.max.spread.mx <- z.min.spread.mx*-1

z.min.spread.mn <- min(SIMseamin.proj.NOST.spread - SIMseamin.proj.ST.spread)
z.max.spread.mn <- z.min.spread.mn*-1

pdf(file="~/Desktop/Dissertation/Defense/figures/OND2010-spr.pdf",width=12,height=3.5,pointsize=20)
par(mfrow=c(1,3),mar=c(2,2,2,2))

seatot.spr <- raster(matrix(SIMseatot.proj.NOST.spread - SIMseatot.proj.ST.spread,nrow=74,ncol=70,byrow=T))
extent(seatot.spr) <- ext 
image.plot(flip(seatot.spr,2),zlim=c(z.min.spread.pp,z.max.spread.pp),xlab="",ylab="",main="Precip",col=diff.colors.pp,axes=F,legend.mar=7.1)
plot(Salado_A_gk,add=T,lwd=2)
box()

seamax.spr <- raster(matrix(SIMseamax.proj.NOST.spread - SIMseamax.proj.ST.spread,nrow=74,ncol=70,byrow=T))
extent(seamax.spr) <- ext
image.plot(flip(seamax.spr,2),zlim=c(z.min.spread.mx,z.max.spread.mx),xlab="",ylab="",main="Max Temp",col=diff.colors,axes=F,legend.mar=7.1)
plot(Salado_A_gk,add=T,lwd=2)
box()

seamin.spr <- raster(matrix(SIMseamin.proj.NOST.spread - SIMseamin.proj.ST.spread,nrow=74,ncol=70,byrow=T))
extent(seamin.spr) <- ext
image.plot(flip(seamin.spr,2),zlim=c(z.min.spread.mn,z.max.spread.mn),xlab="",ylab="",main="Min Temp",col=diff.colors,axes=F,legend.mar=7.1)
plot(Salado_A_gk,add=T,lwd=2)
box()

dev.off()

